// uncache-loader.js
// This adds cache-busting timestamps to all script tags to prevent browser caching during development

(function () {
  const timestamp = Date.now();
  
  // Find all script tags in the document
  const scripts = document.querySelectorAll('script[src]');
  
  scripts.forEach(script => {
    const src = script.getAttribute('src');
    
    // Only add timestamp to local JS files (not external libraries or already timestamped URLs)
    if (src && src.startsWith('js/') && !src.includes('?v=') && !src.includes('lzma')) {
      script.setAttribute('src', `${src}?v=${timestamp}`);
    }
  });
})();

