// Unified test runner for all testing pages
// Supports expectedOutput and customValidator per test

(function() {
    // Example test definition:
    // {
    //     description: "Test description",
    //     script: "put 2 + 2",
    //     expectedOutput: "4"
    // }
    // or
    // {
    //     description: "Test time output",
    //     script: "put the time",
    //     customValidator: function(output) {
    //         return /\d{1,2}:\d{2}(:\d{2})?\s*(AM|PM)?/.test(output);
    //     }
    // }

    function runTest(test, interpreter, outputHandler) {
        let output = "";
        let oldOutputHandler = window.outputHandler;
        window.outputHandler = function(str) { output += str; };
        try {
            interpreter.interpret(test.script);
        } catch (e) {
            output = "ERROR: " + e.message;
        }
        window.outputHandler = oldOutputHandler;

        let passed = false;
        if (typeof test.customValidator === "function") {
            try {
                passed = test.customValidator(output);
            } catch (e) {
                passed = false;
            }
        } else if (typeof test.expectedOutput !== "undefined") {
            passed = (output.trim() === test.expectedOutput.trim());
        }
        return { passed: passed, output: output };
    }

    window.runAllTests = function(testSuite, interpreter) {
        let results = [];
        for (let i = 0; i < testSuite.length; i++) {
            let test = testSuite[i];
            let result = runTest(test, interpreter);
            results.push({
                description: test.description,
                passed: result.passed,
                output: result.output,
                expectedOutput: test.expectedOutput,
                customValidator: typeof test.customValidator === "function"
            });
        }
        return results;
    };

    // Optionally, expose runTest for single-test execution
    window.runTest = runTest;

})();
